//
//  PBXArchive.h
//  VerpackIt
//
//  Created by Uli Kusterer on 15.09.04.
//  Copyright 2004 M. Uli Kusterer. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class PBXProject;


@interface PBXArchive : NSObject
{
	NSString*				archiveVersion;
	PBXProject*				rootObject;
	NSDictionary*			fileDictionary;
	NSMutableDictionary*	nameToObject;
	NSString*				projectPath;
}

-(id)			initWithDictionary: (NSDictionary*)pbxProjFile
					projectPath: (NSString*)projPath;

-(PBXProject*)	rootObject;

-(NSString*)	projectPath;
-(NSString*)	projectFolderPath;
-(NSString*)	buildProductPath;

// private:
-(id)	inflateObject: (NSString*)nm;

@end
