//
//  PBXProject.h
//  VerpackIt
//
//  Created by Uli Kusterer on 15.09.04.
//  Copyright 2004 M. Uli Kusterer. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "PBXArchive.h"

@class	PBXGroup;
@class	PBXBuildStyle;
@class	PBXNativeTarget;

@interface PBXProject : NSObject
{
	BOOL			hasScannedForEncodings;
	NSString*		projectDirPath;
	NSMutableArray*	buildStyles;
	NSMutableArray*	targets;
	PBXGroup*		mainGroup;
	NSDictionary*	objectData;
}

-(id)				initWithObjData: (NSDictionary*)objData archive: (PBXArchive*)arc;

-(PBXGroup*)		mainGroup;

-(int)				buildStyleCount;
-(PBXBuildStyle*)	buildStyleAtIndex: (int)n;

-(int)				targetCount;
-(PBXNativeTarget*)	targetAtIndex: (int)n;

@end
