//
//  PBXBuildPhase.m
//  VerpackIt
//
//  Created by Uli Kusterer on 15.09.04.
//  Copyright 2004 M. Uli Kusterer. All rights reserved.
//

#import "PBXBuildPhase.h"


@implementation PBXBuildPhase

-(id)	initWithObjData: (NSDictionary*)objData archive: (PBXArchive*)arc
{
	self = [super init];
	if( self )
	{
		objectData = [objData retain];
		files = [[NSMutableArray alloc] init];

		// Files:
		NSEnumerator*	enny = [[objData objectForKey: @"files"] objectEnumerator];
		NSString*		objName;
		id				obj;
		
		while( (objName = [enny nextObject]) )
		{
			obj = [arc inflateObject: objName];
			if( obj ) [files addObject: obj];
		}
				
		runOnlyForDeploymentPostprocessing = [[objData objectForKey: @"runOnlyForDeploymentPostprocessing"] retain];
		productInstallPath = [[objData objectForKey: @"productInstallPath"] retain];
		buildActionMask = [[objData objectForKey: @"buildActionMask"] retain];
	}
	
	return self;
}


- (void) dealloc
{
    [objectData release];
    [files release];
    [runOnlyForDeploymentPostprocessing release];
    [buildActionMask release];
    [productInstallPath release];

    objectData = nil;
    files = nil;
    runOnlyForDeploymentPostprocessing = nil;
    buildActionMask = nil;
    productInstallPath = nil;

    [super dealloc];
}


-(NSString*)	description
{
	return [NSString stringWithFormat: @"%@ { productInstallPath = %@, buildActionMask = %@, runOnlyForDeploymentPostprocessing = %@ }",
						NSStringFromClass([self class]),
						productInstallPath, buildActionMask, runOnlyForDeploymentPostprocessing];
}


-(int)						count
{
	return [files count];
}

-(id)	objectAtIndex: (int)n
{
	return [files objectAtIndex: n];
}


@end
