//
//  UKTurbo264.h
//  UKTurboExport
//
//  Created by Uli Kusterer on 09.02.08.
//  Copyright 2008 M. Uli Kusterer. All rights reserved.
//

/*
	This is a class that implements a singleton object through which you can
	talk to Elgato's Turbo.264 device from a Cocoa app. It lets you detect the
	presence of the device and QuickTime component, sends out notifications
	when the device is plugged in or unplugged, and lets you list the presets
	available.
	
	Note that the presets are currently a hard-coded list, you can't get at
	the custom presets right now.
*/

// -----------------------------------------------------------------------------
//	Headers:
// -----------------------------------------------------------------------------

#import <Cocoa/Cocoa.h>


// -----------------------------------------------------------------------------
//	Forwards:
// -----------------------------------------------------------------------------

struct UKTurbo264IVars;	// private.


// -----------------------------------------------------------------------------
//	Class:
// -----------------------------------------------------------------------------

@interface UKTurbo264 : NSObject
{
	struct UKTurbo264IVars*	_ivars;	// All ivars are private.
}

+(id)				sharedTurbo264;

-(BOOL)				isAvailable;	// Is the Turbo Component installed and a device plugged in right now?

-(NSArray*)			exportPresets;	// NSArray of NSDictionaries with the list of supported presets (built-in only right now). Empty array if no component installed.
-(NSDictionary*)	exportPresetForID: (NSString*)presetIdentifier;			// presetIdentifier is a UKTurbo264PresetIdentifierKey value.

-(NSData*)			exportSettingsFromPreset: (NSDictionary*)preset;		// Takes exportPreset, gives QTMovieExportSettings NSData block.

-(NSDictionary*)	writeToFileAttributesForPreset: (NSDictionary*)preset;	// Returns an attributes dictionary with QTMovieExportSettings and all other keys set up correctly for QTMovie -writeToFile:.

@end


// -----------------------------------------------------------------------------
//	Constants:
// -----------------------------------------------------------------------------

// Turbo.264 component types as we pass them to QuickTime:
#define kElgatoManufacturer				'ElGt'
#define kTurboExporterType				'Turb'

// exportPresets dictionary fields:
extern NSString*	UKTurbo264PresetIdentifierKey;		// NSString with unique identifier of preset. Use this if you want to save the current preset to persistent storage.
extern NSString*	UKTurbo264PresetDisplayNameKey;		// NSString with localized name of preset.
extern NSString*	UKTurbo264PresetInternalIDKey;		// NSNumber containing a long with the actual type to hand to the exporter.

// Notifications sent by UKTurbo264: (call [UKTurbo264 sharedTurbo264] at startup or you won't get these)
extern NSString*	UKTurbo264DeviceCountChangedNotification;



