/* =============================================================================
	POJECT:		UKProgressPanel
	AUTHORS:	M. Uli Kusterer (UK), (c) 2003, all rights reserved.
	REQUIRES:	UKProgressPanel.m
				UKProgressPanel.nib
				UKProgressPanel.strings
				UKProgressPanelTask.h
				UKProgressPanelTask.m
				(UKProgressPanelTask.nib)
   ========================================================================== */

/** MT-Newswatcher/Finder-style progress window for keeping the user current on
	concurrently running tasks.
	
	The only interesting part of the UKProgressPanel class really is the
	category at the bottom of the file. It implements the IBAction
	orderFrontProgressPanel:, which you can use to implement a menu
	item to show the progress panel.

	\note   UKProgressPanel and UKProgressPanelTask are thread-safe. */
	

/* -----------------------------------------------------------------------------
	Headers:
   -------------------------------------------------------------------------- */

#import <Cocoa/Cocoa.h>


// Set this in compiler flags using -DUK_PROGRESS_PANEL_SAFARI_STYLE=1
//	Don't change this file.
#ifndef UK_PROGRESS_PANEL_SAFARI_STYLE
	#define UK_PROGRESS_PANEL_SAFARI_STYLE		1
#endif



/* -----------------------------------------------------------------------------
	Forwards:
   -------------------------------------------------------------------------- */

@class UKProgressPanelTask;		// Forward declaration.


/* -----------------------------------------------------------------------------
	Controller:
   -------------------------------------------------------------------------- */

@interface UKProgressPanel : NSObject
{
	// All instance variables are *private*:
    IBOutlet NSView			*taskContentView;	///< View that we add our progress elements' views to.
    IBOutlet NSTextField	*taskStatus;		///< Status field displaying the number of tasks.
	IBOutlet NSWindow		*taskListWindow;	///< The window in which we display our task list.
	NSMutableArray			*unretainedTasks;	///< An array that doesn't retain its objects where we keep a list of all tasks.
}

+(UKProgressPanel*)	sharedProgressPanel;		///< Returns the shared progress panel instance.


-(void)			orderFront: (id)sender;			///< Bring this instance's window to the front.
-(void)			stopAllTasks: (id)sender;		///< Cancel all running tasks.

-(NSString*)	windowNibName;


// Private (automatically done for you on task creation):
-(void)			addProgressPanelTask: (UKProgressPanelTask*)element;
-(void)			removeProgressPanelTask: (UKProgressPanelTask*)element;

@end


/* -----------------------------------------------------------------------------
	Progress Panel NSApplication category:
   -------------------------------------------------------------------------- */

@interface NSApplication (UKProgressPanel)

/// Use this for implementing a "Tasks" or "Show Progress Panel" menu item:
-(IBAction)			orderFrontProgressPanel: (id)sender;	///< Create and show the progress panel.

@end